package gov.va.med.mhv.phr.chemlabs.decorator;

import gov.va.med.mhv.phr.decorator.DecoratorUtils;
import gov.va.med.mhv.phr.transfer.ChemLabsTestLab;
import gov.va.med.mhv.phr.transfer.ImpreciseDateComposite;

import java.util.Date;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;


public class ChemLabsTestLabTableDecorator { 
	
	private ChemLabsTestLab testLab;

    protected static final String UNKNOWN = 
        StringEscapeUtils.escapeHtml("Unknown");
    
    protected static final String BLANK = StringEscapeUtils.escapeHtml("");
    
    public ChemLabsTestLabTableDecorator(ChemLabsTestLab testLab) {
    	this.testLab = testLab;
    }
    
    protected static String escapedValueOrBlank(String value) {
        return StringUtils.isBlank(value) ? BLANK : escapedValue(value);
    }

    protected static String escapedValue(String value) {
        return StringEscapeUtils.escapeHtml(value);
    }

    public String getCollectedOn() {
    	if(getTestLab()!=null){
	    	ImpreciseDateComposite collectedOn = getTestLab().
	            getCollectedOnComposite();
	        if (collectedOn == null) {
	            return UNKNOWN;
	        }else{
	        	return collectedOn.getImpreciseValue();
	        }
    	}
        else{
    		return "";
    	}        
    }
    
    public Date getCollectedOnDate() {
    	if(getTestLab()!=null){
	        ImpreciseDateComposite collectedOn = getTestLab().getCollectedOnComposite();
	        if (collectedOn == null){
	            return new Date();
	        } else if (collectedOn.getValue() != null){
	        	return DecoratorUtils.toDate(getTestLab().getCollectedOnComposite());
	        } else{
	        	return new Date();
	        }
    	}else{
    		return new Date();
    	}     	
    }

    public String getSpecimen() {
    	if(getTestLab()!=null){
    		return escapedValue(getTestLab().getSpecimenSource());
    	}else{
    		return UNKNOWN;
    	}
    }
    
    public String getComments() {
    	if(getTestLab()!=null){
    		return escapedValueOrBlank(getTestLab().getComments());
    	}else{
    		return BLANK;
    	}
    }
    
    public String getOrderingLocation() {
    	if(getTestLab()!=null){
    		return escapedValue(getTestLab().getOrderingLocation());
    	}else{
    		return UNKNOWN;
    	}
    }    
    
    public String getOrderingProvider() {
    	if(getTestLab()!=null){
    		return escapedValue(getTestLab().getOrderingProvider());
    	}else{
    		return UNKNOWN;
    	}
    }
        
    /**
     * 
     * @return indication if this test lab has been amended
     */
    @SuppressWarnings("unchecked")
    public boolean getAmended() {	
    	if(getTestLab()!=null){
    		return getTestLab().getAmendedStatus();
    	}else{
    		return false;
    	}
    }    
    
    private ChemLabsTestLab getTestLab() {
        return testLab;
    }

	public Long getId() {
		return testLab.getId();
	}

}
